﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Reflection;
using System.Text;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{

    public partial class AHOBPRLinqDataContext 
    {
        [Function(Name = "GetDate", IsComposable = true)]
        public DateTime GetSystemDate()
        {
            MethodInfo mi = MethodBase.GetCurrentMethod() as MethodInfo;
            return (DateTime)this.ExecuteMethodCall(this, mi, new object[] { }).ReturnValue;
        }
      
    }

    public class AHOBPRDataAccess : AHOBPRLinqDataContext
    {
 
        #region Constructors

        public AHOBPRDataAccess(string connection) : base (connection)
        {
            InitializeDataContextDebugger();
        }
        
        public AHOBPRDataAccess(System.Data.IDbConnection connection) : base (connection)
        {
            InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(string connection, System.Data.Linq.Mapping.MappingSource mappingSource) : base(connection, mappingSource)
        {
            InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(System.Data.IDbConnection connection, System.Data.Linq.Mapping.MappingSource mappingSource)
            : base(connection, mappingSource)
        {
            InitializeDataContextDebugger();
        }

        #endregion        

        public void InitializeDataContextDebugger()
        {
            if (GlobalSettings.DalLogLing)
            {
                //this.Log = new Utilities.DebuggerWriter();
            }

        }

        public override void SubmitChanges(ConflictMode failureMode)
        {

            ChangeSet changeSet = this.GetChangeSet();

            string user = string.IsNullOrEmpty(System.Threading.Thread.CurrentPrincipal.Identity.Name) ? "REST Service" : System.Threading.Thread.CurrentPrincipal.Identity.Name;
            DateTime now = GetSystemDate(); 
            var updates = (from t in changeSet.Updates select t);

            foreach (object o in changeSet.Inserts)
            {
                Type type = o.GetType();

                PropertyInfo propCreatedBy = type.GetProperty("CREATEDBY");
                if (propCreatedBy.GetValue(o, null) == null ||
                    propCreatedBy.GetValue(o, null).ToString() == "")
                {
                    propCreatedBy.SetValue(o, user, null);
                }

                PropertyInfo propCreated = type.GetProperty("CREATED");
                propCreated.SetValue(o, now, null);


                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                if (propUpdatedBy.GetValue(o, null) == null ||
                    propUpdatedBy.GetValue(o, null).ToString() == "")
                {
                    propUpdatedBy.SetValue(o, user, null);
                }

                PropertyInfo propUpdated = type.GetProperty("UPDATED");
                propUpdated.SetValue(o, now, null);

            }

            foreach (object o in changeSet.Updates)
            {
                Type type = o.GetType();

                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                if (propUpdatedBy.GetValue(o, null) == null ||
                    propUpdatedBy.GetValue(o, null).ToString() == "")
                {
                    propUpdatedBy.SetValue(o, user, null);
                }

                PropertyInfo propUpdated = type.GetProperty("UPDATED");
                propUpdated.SetValue(o, now, null);
            }


            //force connection to open

            if (this.Connection.State != ConnectionState.Open)
            {
                this.Connection.Open();
            }
            //SetContextInfo to username
            this.sp_SetContextInfo(user);

            base.SubmitChanges(failureMode);

            //Set Context Info back to empty string
            this.sp_SetContextInfo("");


        }

        public ITable GetTableWithInheritance(DataContext data, Type type)
        {
            try
            {
                return data.GetTable(type);
            }
            catch
            {
                return GetTableWithInheritance(data, type.BaseType); // error was here
            }
        }
       
    }
}
